function Qalpha = qlimit(eigenvalue,ncomp, climit) 
%
% qlimit function estimates de Q residual limits for a delimited value of
% confidence limit. 
%
% This is possible provided that all of the eigenvalues of the covariance
% matrix X have been obtained (?). It's calculated based on the Jackson-Mudholkar studies.
%   
%   -------------------------------INPUT-----------------------------------
%   eigenvalue  matrix of data calculated in pca_svd function        
% 
%   ncomp       Number of componets (spectra) to fit.
%    
%   climit      The confidence limit expressed as a fraction
%
%   -------------------------------OUTPUT----------------------------------
%   Qlim        A value of the confidence limit
%
%   See also: pca_svd, t2limit
% 
% 	References: 
%   Jackson, J. E., & Mudholkar, G. S. (1979). Control Procedures for 
%   Residuals Associated with Principal Component Analysis. Technometrics, 
%   21(3), 341. doi:10.2307/1267757 
%
%   Bro, R., & Smilde, A. K. (2014). Principal component analysis. 
%   Anal. Methods, 6(9), 2812–2831. doi:10.1039/c3ay41907j 
%
%   This is a part of the GNAT        
%   Copyright  2017  <Mathias Nilsson>%
%   This program is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License along
%   with this program; if not, write to the Free Software Foundation, Inc.,
%   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
%
%   Dr. Mathias Nilsson
%   School of Chemistry, University of Manchester,
%   Oxford Road, Manchester M13 9PL, UK
%   Telephone: +44 (0) 161 306 4465
%   Fax: +44 (0)161 275 4598
%   mathias.nilsson@manchester.ac.uk
%%

theta1 = sum(eigenvalue(ncomp+1:end));
theta2 = sum(eigenvalue(ncomp+1:end).^2);
theta3 = sum(eigenvalue(ncomp+1:end).^3);

h0 = 1-(2*theta1*theta3)/(3*(theta2.^2));
if h0<0.001
    h0 = 0.001;
end

ca = sqrt(2)*erfinv(2*(climit-1));
a = (ca*h0*sqrt(2*theta2))/theta1;
b = (theta2*h0*(h0-1))/(theta1.^2);
Qalpha = (theta1*(1 + a + b)).^1/h0;



